;coded by UEZ build 2016-01-08
;thanks to Eukalyptus for the GDIPlusEx UDF!

;~ #AutoIt3Wrapper_AU3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#pragma compile(Icon, "c:\Program Files (x86)\AutoIt3\Icons\au3.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /rm ;/pe
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <Date.au3>
#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>
#include "BassConstants.au3"
#include "Bass.au3"

_GDIPlus_Startup()
Global $hGUI, $iFPS = 0, $iFrames = 0, $iShowFPS = 0, $fTimer, $bExit, $aAudio
Global Const $iW = @DesktopWidth, $iH = @DesktopHeight, $iWh = $iW / 2, $iHh = $iH / 2, $sTitle = "GDI+ Simple Firework v2 by UEZ"
Global Const $fRad = ACos(-1) / 180, $iMaxParticles = 61, $iFireworks = 10, $iParticleSize = 4, $bBlur = False, $iBlurLevel = 3
Global $bWait4NewYear = False ;change this to true to start countdown timer

Global $iElements = 9, $aCoords[$iFireworks][$iElements + $iMaxParticles * 4 - 3] ;don't touch these values
AutoItSetOption("GUIOnEventMode", 1)

Init_GDIPlusEx()
GDIPlus_SimpleFirework()

_GDIPlus_Shutdown()


Func GDIPlus_SimpleFirework()
	$bExit = False
	$hGUI = GUICreate($sTitle & 0, $iW, $iH, 0, 0, $WS_POPUP)
	GUISetState(@SW_SHOW, $hGUI)
	WinSetTrans($hGUI, "", 0xF8)
	GUISetCursor(16, 1)

	;create canvas elements
	Local $oBuffer = _GDIPlusEx_BufferCreate($hGUI)
	_GDIPlus_GraphicsSetSmoothingMode($oBuffer.Gfx, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($oBuffer.Gfx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)
	Local Const $hBrush = _GDIPlus_BrushCreateSolid(0xFFE0E0E0), _
			$hBrush_Clr = _GDIPlus_BrushCreateSolid(0xA0000000), _
			$hBrush_Txt = _GDIPlus_BrushCreateSolid(0x10202020), $hBrush_FPS = _GDIPlus_BrushCreateSolid(0xA0505050), $hBrush_CD = _GDIPlus_BrushCreateSolid(0x70202020), _
			$hFormat = _GDIPlus_StringFormatCreate(), $hFormat_FPS = _GDIPlus_StringFormatCreate(), _
			$hFamily = _GDIPlus_FontFamilyCreate("Impact"), $hFamily_FPS = _GDIPlus_FontFamilyCreate("Arial"), $hFamily_CD = _GDIPlus_FontFamilyCreate("Arial Black"), _
			$hFont = _GDIPlus_FontCreate($hFamily, $iH / 4.5), $hFont_FPS = _GDIPlus_FontCreate($hFamily_FPS, 8), $hFont_CD = _GDIPlus_FontCreate($hFamily_CD, $iH / 4.5), _
			$tLayout = _GDIPlus_RectFCreate(0, 0, $iW, $iH), $tLayout_FPS = _GDIPlus_RectFCreate(0, 0, 150, 32)
	_GDIPlus_StringFormatSetAlign($hFormat, 1)
	_GDIPlus_StringFormatSetLineAlign($hFormat, 1)

	Local $iX, $iY, $j = -2^32 + 1, $bAudio = True, $iFXLength, $iCurrentYear = @YEAR

	;init sound
	_BASS_STARTUP()
	_BASS_Init(0, -1, 44100, 0, "")
	If @error Then $bAudio = False

	Local $aAudio[$iFireworks][2], $hAudio_Whoa, $hAudio_BgNoise
	For $iY = 0 To $iFireworks - 1 ;generated firework particles
		GenCoordinates($iY, $aCoords, 1.5, 3.5, 1, 5.5)
		If $bAudio Then
			$aAudio[$iY][0] = _BASS_StreamCreateFile(False, @ScriptDir & "\" & Random(1, 7, 1) & ".mp3", 0, 0, 0)
			$aAudio[$iY][1] = 0
		EndIf
	Next
	$hAudio_Whoa = _BASS_StreamCreateFile(False, @ScriptDir & "\ApplauseWoah.mp3", 0, 0, 0)
	$hAudio_BgNoise = _BASS_StreamCreateFile(False, @ScriptDir & "\BgNoise.mp3", 0, 0, 0)
	If Not $bWait4NewYear Then _BASS_ChannelPlay($hAudio_BgNoise, True)
	$iFXLength = _BASS_ChannelGetLength($hAudio_BgNoise, $BASS_POS_BYTE)

	$iFPS = 0
	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	AdlibRegister("CalcFPS", 1000)
	Local $iAlpha, $iCounterFX = 0, $iCounterParticles = 0, $b
	$fTimer = TimerInit()

	Do
		Switch $bWait4NewYear
			Case True
				_GDIPlus_GraphicsClear($oBuffer.Gfx)
				_GDIPlus_GraphicsDrawStringEx($oBuffer.Gfx, Sec_2_Time_Format(_DateDiff("s", _NowCalc(), @YEAR + 1 & "/01/01 00:00:00")), $hFont_CD, $tLayout, $hFormat, $hBrush_CD)
				If $iCurrentYear <> @YEAR Then
					_BASS_ChannelPlay($hAudio_BgNoise, True)
					$bWait4NewYear = False
				EndIf
			Case Else
				DllCall($__g_hGDIPDll, "int", "GdipFillRectangle", "handle", $oBuffer.Gfx, "handle", $hBrush_Clr, "float", 0, "float", 0, _
				"float", $iW, "float", $iH) ;erase canvas background
				_GDIPlus_GraphicsDrawStringEx($oBuffer.Gfx, "Happy new year " & @YEAR, $hFont, $tLayout, $hFormat, $hBrush_Txt) ;draw background message text
				For $iY = 0 To $iFireworks - 1 ;calculate and draw firework particles
					If $aCoords[$iY][1] > $aCoords[$iY][4] Then ;draw rocket only until explosion
						$aCoords[$iY][0] += $aCoords[$iY][2] ;x vector
						$aCoords[$iY][1] -= Abs($aCoords[$iY][3] * 10) ;y vector should be in upper direction only
						_GDIPlus_BrushSetSolidColor($hBrush, 0x60909090)
						DllCall($__g_hGDIPDll, "int", "GdipFillRectangle", "handle", $oBuffer.Gfx, "handle", $hBrush, "float", $aCoords[$iY][0], "float", $aCoords[$iY][1], "float", 2, "float", 2)
						$iCounterParticles += 1
						For $iX = $iElements To UBound($aCoords, 2) - 5 Step 4
							$aCoords[$iY][$iX] = $aCoords[$iY][0] ;copy x position
							$aCoords[$iY][$iX + 1] = $aCoords[$iY][1] ;copy y position
						Next
					Else
						For $iX = $iElements To UBound($aCoords, 2) - 5 Step 4
							$aCoords[$iY][$iX] += $aCoords[$iY][$iX + 2] ;x coordinate
							$aCoords[$iY][$iX + 1] += $aCoords[$iY][$iX + 3] + $aCoords[$iY][8] ;y coordinate
							$aCoords[$iY][$iX + 2] *= 0.98 ;neg. accelaration of x vector
							$aCoords[$iY][$iX + 3] *= 0.98 ;neg. accelaration of y vector
							$iAlpha = $aCoords[$iY][6] > 0xFF ? 0xFF : $aCoords[$iY][6]
							Switch $aCoords[$iY][7] ;choose color mode
								Case 0
									$b = True
									Switch Mod($j, 2)
										Case 0
											_GDIPlus_BrushSetSolidColor($hBrush, Int($iAlpha) * 0x1000000 + 0x10000 * Random(0xD0, 0xFF, 1) + 0x100 * Random(0xD0, 0xFF, 1) + Random(0xD0, 0xFF, 1))
										Case Else
											_GDIPlus_BrushSetSolidColor($hBrush, Int($iAlpha) * 0x1000000 + $aCoords[$iY][5])
									EndSwitch
								Case Else
									$b = False
									_GDIPlus_BrushSetSolidColor($hBrush, Int($iAlpha) * 0x1000000 + $aCoords[$iY][5])
							EndSwitch
							;draw only visible particles
							If BitAND($aCoords[$iY][$iX] > -1, $aCoords[$iY][$iX] < $iW, $aCoords[$iY][$iX + 1] > -1, $aCoords[$iY][$iX + 1] < $iH) Then
								DllCall($__g_hGDIPDll, "int", "GdipFillEllipse", "handle", $oBuffer.Gfx, "handle", $hBrush, _
														"float", $aCoords[$iY][$iX], "float", $aCoords[$iY][$iX + 1], _
														"float", $iParticleSize, "float", $iParticleSize) ;draw firework particles
								$iCounterParticles += 1
							EndIf
						Next
						If $b Then $j += 1
						$aCoords[$iY][6] *= 0.933 ;decrease alpha channel
						$aCoords[$iY][8] *= 1.075 ;gravity accelaration (y axis) -> earth's gravitational force simulation
						If Not $aAudio[$iY][1] And $bAudio Then ;play audio fx
							_BASS_ChannelPlay($aAudio[$iY][0], False)
							$aAudio[$iY][1] = 1
							$iCounterFX += 1
						EndIf
						If $aCoords[$iY][6] < 0x0D Then ;reset firework elements
							$aAudio[$iY][1] = 0
							GenCoordinates($iY, $aCoords)
						EndIf
					EndIf
				Next
				If $iCounterFX > 2 Then
					_BASS_ChannelPlay($hAudio_Whoa, False)
				EndIf
				If _BASS_ChannelGetPosition($hAudio_BgNoise, $BASS_POS_BYTE) >= $iFXLength Then _BASS_ChannelPlay($hAudio_BgNoise, True)
				If $bBlur Then _GDIPlusEx_EffectBlurBitmap($oBuffer, $iBlurLevel)
				_GDIPlus_GraphicsDrawStringEx($oBuffer.Gfx, "FPS: " & $iShowFPS & @CRLF & "Particles: " & $iCounterParticles, $hFont_FPS, $tLayout_FPS, $hFormat_FPS, $hBrush_FPS) ;draw background message text
				$iCounterFX = 0
				$iCounterParticles = 0
				$iFPS += 1
				$iFrames += 1
		EndSwitch
		_GDIPlusEx_BufferDraw($oBuffer)
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	;release resources
	_GDIPlus_FontDispose($hFont)
	_GDIPlus_FontDispose($hFont_FPS)
	_GDIPlus_FontDispose($hFont_CD)
	_GDIPlus_FontFamilyDispose($hFamily)
	_GDIPlus_FontFamilyDispose($hFamily_CD)
	_GDIPlus_FontFamilyDispose($hFamily_FPS)
	_GDIPlus_StringFormatDispose($hFormat)
	_GDIPlus_StringFormatDispose($hFormat_FPS)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_BrushDispose($hBrush_Clr)
	_GDIPlus_BrushDispose($hBrush_Txt)
	_GDIPlus_BrushDispose($hBrush_FPS)
	_GDIPlus_BrushDispose($hBrush_CD)
	$oBuffer = Null
	GUIDelete($hGUI)
	If $bAudio Then
		For $iY = 0 To $iFireworks - 1
			_BASS_ChannelStop($aAudio[$iY][0])
		Next
		_BASS_ChannelStop($hAudio_Whoa)
		_BASS_ChannelStop($hAudio_BgNoise)
		_BASS_Free()
	EndIf
EndFunc   ;==>GDIPlus_SimpleFirework

Func GenCoordinates($iY, ByRef $aCoords, $fVXmin = 2.5, $fVXmax = 15.5, $fVYmin = 1.5, $fVYmax = 5.5)
	Local $aColors[7] = [0xFF0000, 0x00FF00, 0x0000FF, 0xFFFF00, 0xFF7514, 0xFFFFFF, 0x40E0D0]
	$aCoords[$iY][0] = $iWh	;x coordinate (x coordinate of starting point)
	$aCoords[$iY][1] = $iH	;y coordinate (y coordinate of starting point)
	$aCoords[$iY][2] = Random($fVXmin, $fVXmax) * (Random(0, 1, 1) = 0 ? -1 : 1) 	;x vector (direction of rocket)
	$aCoords[$iY][3] = Random($fVYmin, $fVYmax) * (Random(0, 1, 1) = 0 ? -1 : 1)	;y vector (direction of rocket)
	$aCoords[$iY][4] = Random($iH * 0.15, $iH * 0.35) ;area of detonation
;~ 	$aCoords[$iY][5] = 0x10000 * Random(0x40, 0xE0, 1) + 0x100 * Random(0x40, 0xE0, 1) + Random(0x40, 0xE0, 1) ;random color
	$aCoords[$iY][5] = $aColors[Random(0, 6, 1)] ;random color
	$aCoords[$iY][6] = 0x250 ;alpha channel value
	$aCoords[$iY][7] = Random(0, 8, 1) ;value for color mode
	$aCoords[$iY][8] = 0.15 ;gravity accelaration (y axis) initial value

	Local $iX, $fSpeed, $fRadius, $iFX = Random(1, 50, 1), $e = Random(5, 25), $h = 0, $g = 360 / ($iMaxParticles - 1), _
		  $j = 360 / 10, $jj = $j, $k = Random(0.5, 1.5), $kk = Random(1, 3.5), $l = 0
	For $iX = $iElements To UBound($aCoords, 2) - 5 Step +4
		Switch $iFX ;create some simple firework fx
			Case 1 To 3
				$fSpeed = Cos($g * $iFX * $e * $iX) * $e
				$fRadius = $fSpeed / 2
			Case 4 To 6
				$fSpeed = Sin($iX / 7.85) * $e ;particle speed (explosion strength)
				$fRadius = $fSpeed / 2
			Case 7 To 9
				$fSpeed = Tan($iX / 2) + $e ;particle speed (explosion strength)
				$fRadius = $fSpeed / 2
			Case 10 To 12
				$fSpeed = Cos($iX / 2.5) + $e ;particle speed (explosion strength)
				$fRadius = $fSpeed / 2
			Case 13 To 15	;create circular effect
				$fSpeed = Random($e, $e + 0.333333) ;particle speed (explosion strength)
				$fRadius = $fSpeed / 2
			Case 16 To 18
				$fSpeed = $e
				$fRadius = $k
				$h = $jj
				$jj += $j
				If $jj > 360 Then
					$jj = $j - $l
					$k += $kk
					$l += Random(1, 15)
				EndIf
			Case Else
				$fSpeed = Random(5, 25) ;particle speed (explosion strength)
				$fRadius = $fSpeed / 2
		EndSwitch
		$aCoords[$iY][$iX + 2] = ($fSpeed + Cos($h * $fRad) * $fRadius) - $fSpeed 	;x vector particle speed
		$aCoords[$iY][$iX + 3] = ($fSpeed + Sin($h * $fRad) * $fRadius) - $fSpeed	;y vector particle speed
		$h += $g ;next angle
	Next
EndFunc   ;==>GenCoordinates

Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS() ;display FPS
	$iShowFPS = $iFPS & " / Ø " & Round($iFrames / TimerDiff($fTimer) * 1000, 4)
	$iFPS = 0
EndFunc   ;==>CalcFPS

Func Sec_2_Time_Format($time)
	Local $iDays = 0
	Local Const $iSec = Mod($time, 60)
	Local Const $iMin = Mod(Int($time / 60), 60)
	Local $iHr = Int($time / 60 ^ 2)
	If $iHr > 23 Then
		$iDays = Floor($iHr / 24)
		$iHr -= $iDays * 24
	EndIf
	Return StringFormat("%01id\n\r%02i:%02i:%02i", $iDays, $iHr, $iMin, $iSec)
EndFunc   ;==>Sec_2_Time_Format

Func Init_GDIPlusEx()
	Global Const $_cGDIPEX_ISBMP = 0x41455047
	Global Const $_cGDIPEX_ISBUF = 0x42455047
	Global Const $_sGDIPEX_IIDBUF = "{1CB99E61-15BA-4B1F-8C7E-25D00AE60F2D}"
	Global Const $_tagGDIPEX_BUFFER = "Draw int(int;int;uint); Gfx handle(); pBits ptr(); Width int(); Height int(); Stride int();"
	Global Const $_tagGDIPEX_BITMAP = "Bmp handle(); Gfx handle(); Scan0 ptr(); Width int(); Height int(); Stride int(); Draw int(struct*;int;int); DrawRect int(struct*;int;int;uint;uint);"
	Global $_aGDIPEX_ASMSTRUCT[1]
	OnAutoItExitRegister("__GDIPlusEx_OnExit")
	Global Const $_hGDIPEX_GDIPDLL = _GDIPlus_Startup()
	Global Const $_hGDIPEX_MOD_GDI32 = _WinAPI_GetModuleHandle("gdi32.dll")
	Global Const $_hGDIPEX_MOD_GDIPLUS = _WinAPI_GetModuleHandle("gdiplus.dll")
	Global Const $_hGDIPEX_MOD_KERNEL32 = _WinAPI_GetModuleHandle("kernel32.dll")
	Global Const $_hGDIPEX_MOD_USER32 = _WinAPI_GetModuleHandle("User32.dll")
	Global Const $_pGDIPEX_LIB_SELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "SelectObject")
	Global Const $_pGDIPEX_LIB_DELOBJ = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteObject")
	Global Const $_pGDIPEX_LIB_DELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "DeleteDC")
	Global Const $_pGDIPEX_LIB_RELDC = _WinAPI_GetProcAddress($_hGDIPEX_MOD_USER32, "ReleaseDC")
	Global Const $_pGDIPEX_LIB_BITBLT = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDI32, "BitBlt")
	Global Const $_pGDIPEX_LIB_GLOBALFREE = _WinAPI_GetProcAddress($_hGDIPEX_MOD_KERNEL32, "GlobalFree")
	Global Const $_pGDIPEX_LIB_GFXDEL = _WinAPI_GetProcAddress($_hGDIPEX_MOD_GDIPLUS, "GdipDeleteGraphics")
	Global Const $_pGDIPEX_ASM_OBJ_QUERYIF = __GDIPlusEx_ASMCreate("0x538B4424088B5C2410890383400401B8000000005BC20C00", "0x49890883410801B800000000C3")
	Global Const $_pGDIPEX_ASM_OBJ_ADDREF = __GDIPlusEx_ASMCreate("0x8B442404834004018B4004C20400", "0x834108018B4108C3")
	Global Const $_pGDIPEX_ASM_OBJ_RELBUF = __GDIPlusEx_ASMCreate("0x538B5C2408836B0401837B040075448B43388B531C52FFD08B433C8B53288B4B305152FFD08B43408B532052FFD08B43448B532852FFD08B433C8B532C8B4B245152FFD08B433453FFD0B8000000005BC204008B43045BC20400", "0x534889CB836B0801837B080075504883EC20488B4360488B4B28FFD0488B4368488B4B40488B5350FFD0488B4370488B4B30FFD0488B4378488B4B40FFD0488B8380000000488B4B48488B5338FFD0488B43584889D9FFD04883C4205BC38B43085BC3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFDRAW = __GDIPlusEx_ASMCreate("0x5356578B5C24108B7424148B7C2418B8FFFFFFFF817B0847504542752E8B4C241C5183EC08C7042400000000C7442404000000008B5328528B5310528B530C5257568B5324528B434CFFD05F5E5BC21000", "0x534889CB4989D24D89C348C7C0FFFFFFFF81790C47504542754B4883EC484C894C244048C74424380000000048C744243000000000488B43404889442428488B431448894424204D31C9448B4B104D89D84C89D2488B4B38488B8388000000FFD04883C4485BC3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFGFX = __GDIPlusEx_ASMCreate("0x8B5424048B421CC20400", "0x488B4128C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFBITS = __GDIPlusEx_ASMCreate("0x8B5424048B4218C20400", "0x488B4120C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFWIDTH = __GDIPlusEx_ASMCreate("0x8B5424048B420CC20400", "0x8B4110C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFHEIGHT = __GDIPlusEx_ASMCreate("0x8B5424048B4210C20400", "0x8B4114C3")
	Global Const $_pGDIPEX_ASM_OBJ_BUFSTRIDE = __GDIPlusEx_ASMCreate("0x8B5424048B4214C20400", "0x8B4118C3")
	Global Const $_pGDIPEX_ASM_BMPCLR = __GDIPlusEx_ASMCreate("0x8B542404660F6E442408660F70C0008B4A100FAF4A148B5218660F7F0283C21083E9107FF4C20800", "0x660F6EC2660F70C0008B51140FAF5118488B4920660F7F014883C11083EA107FF3C3")
	Global Const $_pGDIPEX_ASM_FXBLUR = __GDIPlusEx_ASMCreate("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
															  "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
EndFunc   ;==>Init_GDIPlusEx

Func _GDIPlusEx_BufferCreate($hWnd, $iWidth = 0, $iHeight = 0)
	$iWidth = Int($iWidth)
	$iHeight = Int($iHeight)
	If $iWidth < 1 Or $iHeight < 1 Then
		Local $aSize = WinGetClientSize($hWnd)
		If $iWidth < 1 Then $iWidth = $aSize[0]
		If $iHeight < 1 Then $iHeight = $aSize[1]
	EndIf
	Local $hDC = _WinAPI_GetDC($hWnd)
	If @error Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $hCDC = _WinAPI_CreateCompatibleDC($hDC)
	Local $tBmpInfo = DllStructCreate("struct; uint Size; uint Width; int Height; short Planes; short BitCount; uint Compression; uint SizeImage; int XPelsPerMeter; int YPelsPerMeter; uint ClrUsed; uint ClrImportant; endstruct;")
	DllStructSetData($tBmpInfo, "Size", DllStructGetSize($tBmpInfo))
	DllStructSetData($tBmpInfo, "Width", $iWidth)
	DllStructSetData($tBmpInfo, "Height", -($iHeight + 4))
	DllStructSetData($tBmpInfo, "Planes", 1)
	DllStructSetData($tBmpInfo, "BitCount", 32)
	Local $aResult = DllCall("gdi32.dll", "handle", "CreateDIBSection", "handle", 0, "struct*", $tBmpInfo, "uint", 0, "ptr*", 0, "handle", 0, "uint", 0)
	If @error Or Not $aResult[0] Or Not $aResult[4] Then
		_WinAPI_DeleteDC($hCDC)
		_WinAPI_ReleaseDC($hWnd, $hDC)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Local $hDib = $aResult[0]
	Local $pBits = $aResult[4]
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then Return SetError(10, $GDIP_ERRABORTED, False)
	Local $pBuffer = $aResult[0]
	Local $tBuffer = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pBits; handle Gfx; handle Dib; handle DC; handle CDC; handle Wnd; handle Obj; ptr pGlobalFree; ptr pGfxDel; ptr pSelObj; ptr pDelObj; ptr pDelDC; ptr pRelDC; ptr pBitBlt; ptr pQueryInterface; ptr pAddRef; ptr pRelease; ptr pDraw; ptr pGetGfx; ptr pGetBits; ptr pGetW; ptr pGetH; ptr pGetStride; endstruct;", $pBuffer)
	DllStructSetData($tBuffer, "pBits", $pBits)
	DllStructSetData($tBuffer, "Dib", $hDib)
	DllStructSetData($tBuffer, "OBJ", _WinAPI_SelectObject($hCDC, $hDib))
	DllStructSetData($tBuffer, "Gfx", _GDIPlus_GraphicsCreateFromHDC($hCDC))
	DllStructSetData($tBuffer, "Width", $iWidth)
	DllStructSetData($tBuffer, "Height", $iHeight)
	DllStructSetData($tBuffer, "Stride", $iWidth * 4)
	DllStructSetData($tBuffer, "DC", $hDC)
	DllStructSetData($tBuffer, "CDC", $hCDC)
	DllStructSetData($tBuffer, "Wnd", $hWnd)
	DllStructSetData($tBuffer, "IsGDIPEX", $_cGDIPEX_ISBUF)
	DllStructSetData($tBuffer, "pGlobalFree", $_pGDIPEX_LIB_GLOBALFREE)
	DllStructSetData($tBuffer, "pGfxDel", $_pGDIPEX_LIB_GFXDEL)
	DllStructSetData($tBuffer, "pSelObj", $_pGDIPEX_LIB_SELOBJ)
	DllStructSetData($tBuffer, "pDelObj", $_pGDIPEX_LIB_DELOBJ)
	DllStructSetData($tBuffer, "pDelDC", $_pGDIPEX_LIB_DELDC)
	DllStructSetData($tBuffer, "pRelDC", $_pGDIPEX_LIB_RELDC)
	DllStructSetData($tBuffer, "pBitBlt", $_pGDIPEX_LIB_BITBLT)
	DllStructSetData($tBuffer, "pQueryInterface", $_pGDIPEX_ASM_OBJ_QUERYIF)
	DllStructSetData($tBuffer, "pAddRef", $_pGDIPEX_ASM_OBJ_ADDREF)
	DllStructSetData($tBuffer, "pRelease", $_pGDIPEX_ASM_OBJ_RELBUF)
	DllStructSetData($tBuffer, "pDraw", $_pGDIPEX_ASM_OBJ_BUFDRAW)
	DllStructSetData($tBuffer, "pGetGfx", $_pGDIPEX_ASM_OBJ_BUFGFX)
	DllStructSetData($tBuffer, "pGetBits", $_pGDIPEX_ASM_OBJ_BUFBITS)
	DllStructSetData($tBuffer, "pGetW", $_pGDIPEX_ASM_OBJ_BUFWIDTH)
	DllStructSetData($tBuffer, "pGetH", $_pGDIPEX_ASM_OBJ_BUFHEIGHT)
	DllStructSetData($tBuffer, "pGetStride", $_pGDIPEX_ASM_OBJ_BUFSTRIDE)
	DllStructSetData($tBuffer, "Vtbl", DllStructGetPtr($tBuffer, "pQueryInterface"))
	DllStructSetData($tBuffer, "RefCnt", 1)
	Local $oBuffer = ObjCreateInterface($pBuffer, $_sGDIPEX_IIDBUF, $_tagGDIPEX_BUFFER)
	If Not IsObj($oBuffer) Then
		_GDIPlus_GraphicsDispose(DllStructGetData($tBuffer, "Gfx"))
		_WinAPI_SelectObject(DllStructGetData($tBuffer, "CDC"), DllStructGetData($tBuffer, "OBJ"))
		_WinAPI_DeleteObject(DllStructGetData($tBuffer, "Dib"))
		_WinAPI_DeleteDC(DllStructGetData($tBuffer, "CDC"))
		_WinAPI_ReleaseDC(DllStructGetData($tBuffer, "Wnd"), DllStructGetData($tBuffer, "DC"))
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pBuffer)
		Return SetError(10, $GDIP_ERRABORTED, False)
	EndIf
	Return $oBuffer
EndFunc   ;==>_GDIPlusEx_BufferCreate

Func _GDIPlusEx_BufferDraw($oBuffer, $iX = 0, $iY = 0, $iROP = 0x00CC0020)
	If Not IsObj($oBuffer) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $iStatus = $oBuffer.Draw($iX, $iY, $iROP)
	If Not $iStatus Then Return SetError($GDIP_ERRABORTED, 2, False)
	Return True
EndFunc   ;==>_GDIPlusEx_BufferDraw

Func _GDIPlusEx_EffectBlurBitmap($oBitmap, $iRadius)
	If Not IsObj($oBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	$iRadius = Int($iRadius)
	If $iRadius < 1 Or $iRadius > 127 Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	Local $tTmp = __GDIPlusEx_BitmapCreate($oBitmap.Width, $oBitmap.Height)
	DllCallAddress("none", $_pGDIPEX_ASM_FXBLUR, "struct*", $tTmp, "struct*", __GDIPlusEx_ObjGetPtr($oBitmap), "int", $iRadius)
	__GDIPlusEx_BitmapDispose($tTmp)
	Return True
EndFunc   ;==>_GDIPlusEx_EffectBlurBitmap

Func __GDIPlusEx_ASMCreate(ByRef Const $bBC32, ByRef Const $bBC64)
	Local $iSize
	Switch @AutoItX64
		Case True
			$iSize = BinaryLen($bBC64)
		Case Else
			$iSize = BinaryLen($bBC32)
	EndSwitch
	Local $aResult = DllCall("kernel32.dll", "ptr", "VirtualAlloc", "ptr", 0, "ulong_ptr", $iSize + 16, "dword", 0x00001000, "dword", 0x00000040)
	If @error Or Not $aResult[0] Then Return SetError(1, 0, False)
	Local $pStruct = Number($aResult[0])
	If Mod($pStruct, 16) Then $pStruct = $pStruct + 16 - Mod($pStruct, 16)
	Local $tStruct = DllStructCreate("byte[" & $iSize & "];", $pStruct)
	Switch @AutoItX64
		Case True
			DllStructSetData($tStruct, 1, $bBC64)
		Case Else
			DllStructSetData($tStruct, 1, $bBC32)
	EndSwitch
	DllCall("kernel32.dll", "bool", "VirtualProtect", "struct*", $pStruct, "ulong_ptr", $iSize, "dword", 16, "dword*", 0)
	Local $iIdx = $_aGDIPEX_ASMSTRUCT[0] + 1
	If $iIdx >= UBound($_aGDIPEX_ASMSTRUCT) Then ReDim $_aGDIPEX_ASMSTRUCT[$iIdx + 1]
	$_aGDIPEX_ASMSTRUCT[0] = $iIdx
	$_aGDIPEX_ASMSTRUCT[$iIdx] = $pStruct
	Return $pStruct
EndFunc   ;==>__GDIPlusEx_ASMCreate

Func __GDIPlusEx_BitmapCreate($iW, $iH, $iColor = 0)
	$iW = Int($iW)
	$iH = Int($iH)
	Local $iStride = $iW * 4
	If Mod($iStride, 16) Then $iStride += 16 - Mod($iStride, 16)
	Local $aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", $iStride * ($iH + 4) * 4 + 32)
	If @error Or Not $aResult[0] Then Return SetError($GDIP_ERRABORTED, 1, False)
	Local $pScan0 = Number($aResult[0])
	$aResult = DllCall("kernel32.dll", "handle", "GlobalAlloc", "uint", 0x40, "ulong_ptr", 256)
	If @error Or Not $aResult[0] Then
		DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", $pScan0)
		Return SetError($GDIP_ERRABORTED, 2, False)
	EndIf
	Local $tBitmap = DllStructCreate("struct; ptr Vtbl; int RefCnt; uint IsGDIPEX; uint Width; uint Height; uint Stride; ptr pScan0; ptr pScan0ORIG; endstruct;", $aResult[0])
	DllStructSetData($tBitmap, "Width", $iW)
	DllStructSetData($tBitmap, "Height", $iH)
	DllStructSetData($tBitmap, "Stride", $iStride)
	DllStructSetData($tBitmap, "pScan0ORIG", $pScan0)
	If Mod($pScan0, 16) Then $pScan0 += 16 - Mod($pScan0, 16)
	DllStructSetData($tBitmap, "pScan0", $pScan0)
	DllStructSetData($tBitmap, "IsGDIPEX", $_cGDIPEX_ISBMP)
	If $iColor Then DllCallAddress("none", $_pGDIPEX_ASM_BMPCLR, "struct*", $tBitmap, "uint", $iColor)
	Return $tBitmap
EndFunc   ;==>__GDIPlusEx_BitmapCreate

Func __GDIPlusEx_BitmapDispose(ByRef $tBitmap)
	If Not IsDllStruct($tBitmap) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, False)
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetData($tBitmap, "pScan0ORIG"))
	DllCall("kernel32.dll", "ptr", "GlobalFree", "struct*", DllStructGetPtr($tBitmap))
	$tBitmap = 0
	Return True
EndFunc   ;==>__GDIPlusEx_BitmapDispose

Func __GDIPlusEx_ObjGetPtr($oObj)
	If Not IsObj($oObj) Then Return SetError($GDIP_ERRINVALIDPARAMETER, 1, 0)
	Local $pPtr
	$oObj.QueryInterface("", $pPtr)
	$oObj.Release
	Return $pPtr
EndFunc   ;==>__GDIPlusEx_ObjGetPtr

Func __GDIPlusEx_OnExit()
	If Not IsArray($_aGDIPEX_ASMSTRUCT) Or UBound($_aGDIPEX_ASMSTRUCT) < 1 Or UBound($_aGDIPEX_ASMSTRUCT, 0) <> 1 Then Return
	If $_aGDIPEX_ASMSTRUCT[0] >= UBound($_aGDIPEX_ASMSTRUCT) Then $_aGDIPEX_ASMSTRUCT[0] = UBound($_aGDIPEX_ASMSTRUCT) - 1
	For $i = 1 To $_aGDIPEX_ASMSTRUCT[0]
		DllCall("kernel32.dll", "bool", "VirtualFree", "ptr", $_aGDIPEX_ASMSTRUCT[$i], "ulong_ptr", 0, "dword", 0x00008000)
	Next
	_GDIPlus_Shutdown()
EndFunc   ;==>__GDIPlusEx_OnExit
